/*
 * Decompiled with CFR 0.152.
 */
package github.meloweh.wolfcompanion.screen;

import github.meloweh.wolfcompanion.WolfCompanion;
import github.meloweh.wolfcompanion.accessor.WolfEntityProvider;
import github.meloweh.wolfcompanion.accessor.WolfXpProvider;
import github.meloweh.wolfcompanion.network.DropWolfChestC2SPayload;
import github.meloweh.wolfcompanion.network.ReleaseWolfC2SPayload;
import github.meloweh.wolfcompanion.screenhandler.WolfInventoryScreenHandler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_10799;
import net.minecraft.class_1277;
import net.minecraft.class_1309;
import net.minecraft.class_1493;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class WolfInventoryScreen
extends class_465<WolfInventoryScreenHandler> {
    private static final class_2960 CHEST_SLOTS_TEXTURE = class_2960.method_60656((String)"container/horse/chest_slots");
    private static final class_2960 TEXTURE = class_2960.method_60656((String)"textures/gui/container/horse.png");
    private static final class_2960 SLOT = class_2960.method_60656((String)"container/slot");
    private static final class_2960 EXPERIENCE_BAR_RESULT_TEXTURE = class_2960.method_60656((String)"container/villager/experience_bar_result");
    private static final class_2960 HALF_HEART = class_2960.method_60656((String)"textures/gui/sprites/hud/heart/half");
    private final class_1493 wolf;
    private final WolfXpProvider wolfXp;
    private final int slotColumnCount;
    private float mouseX;
    private float mouseY;
    private class_1277 wolfInventory;
    private class_1657 player;
    private WolfInventoryScreenHandler handler;
    private static final class_2960 BUTTON_RELEASE_AVAILABLE = WolfCompanion.id("textures/gui/container/release_available.png");
    private static final class_2960 BUTTON_RELEASE_HIGHLIGHTED = WolfCompanion.id("textures/gui/container/release_highlighted.png");
    private static final class_2960 BUTTON_CHEST_AVAILABLE = WolfCompanion.id("textures/gui/container/button_available.png");
    private static final class_2960 BUTTON_CHEST_HIGHLIGHTED = WolfCompanion.id("textures/gui/container/button_highlighted.png");
    private static final class_2960 BUTTON_CHEST_DISABLED = WolfCompanion.id("textures/gui/container/button_disabled.png");
    private static final class_2960 WOLF_ARMOR_SLOT = WolfCompanion.id("textures/gui/container/icon_wolf_armor.png");
    private static final class_2960 EXPERIENCE_BAR_BACKGROUND_TEXTURE = WolfCompanion.id("textures/gui/container/wolf_experience_bar_background_v2.png");
    private static final class_2960 EXPERIENCE_BAR_CURRENT_TEXTURE = WolfCompanion.id("textures/gui/container/wolf_experience_bar_current_v2.png");
    private static final class_2960 HEART_CONTAINER = WolfCompanion.id("textures/gui/container/container.png");
    private static final class_2960 HEART = WolfCompanion.id("textures/gui/container/heart.png");

    public WolfInventoryScreen(WolfInventoryScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.field_2792 = 176;
        this.field_2779 = 184;
        this.field_25270 = this.field_2779 - 111;
        this.slotColumnCount = 5;
        this.wolf = handler.getWolf();
        this.wolfXp = (WolfXpProvider)this.wolf;
        this.wolfInventory = handler.getWolfInventory();
        this.player = inventory.field_7546;
        this.handler = handler;
    }

    public void method_25419() {
        super.method_25419();
    }

    private boolean clickedDropChest(double mouseX, double mouseY) {
        int i = (this.field_22789 - this.field_2792) / 2;
        int j = (this.field_22790 - this.field_2779) / 2;
        return mouseX >= (double)(i + 7) && mouseX < (double)(i + 7 + 18) && mouseY >= (double)(j + 35) && mouseY < (double)(j + 35 + 18);
    }

    private boolean clickedReleaseWolf(double mouseX, double mouseY) {
        int i = (this.field_22789 - this.field_2792) / 2;
        int j = (this.field_22790 - this.field_2779) / 2;
        return mouseX >= (double)(i + 7) && mouseX < (double)(i + 7 + 18) && mouseY >= (double)(j + 35 + 18) && mouseY < (double)(j + 35 + 18 + 18);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.clickedDropChest(mouseX, mouseY) && ((WolfEntityProvider)this.wolf).hasChestEquipped()) {
            ClientPlayNetworking.send((class_8710)new DropWolfChestC2SPayload(this.wolf.method_5667()));
            this.player.method_5783((class_3414)class_3417.field_15015.comp_349(), 0.3f, 0.8f);
        }
        if (this.clickedReleaseWolf(mouseX, mouseY) && this.wolf.method_6181()) {
            ClientPlayNetworking.send((class_8710)new ReleaseWolfC2SPayload(this.wolf.method_5667()));
            this.player.method_5783((class_3414)class_3417.field_15015.comp_349(), 0.3f, 0.8f);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    protected void method_2389(class_332 context, float deltaTicks, int mouseX, int mouseY) {
        int i = (this.field_22789 - this.field_2792) / 2;
        int j = (this.field_22790 - this.field_2779) / 2;
        context.method_25290(class_10799.field_56883, TEXTURE, i, j, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 256);
        if (((WolfEntityProvider)this.wolf).hasChestEquipped() && this.slotColumnCount > 0) {
            context.method_70846(class_10799.field_56883, CHEST_SLOTS_TEXTURE, 90, 54, 0, 0, i + 79, j + 17, this.slotColumnCount * 18, 54);
        }
        if (this.wolf.method_56677()) {
            context.method_52706(class_10799.field_56883, SLOT, i + 7, j + 35 - 18, 18, 18);
        } else {
            context.method_25290(class_10799.field_56883, WOLF_ARMOR_SLOT, i + 7, j + 35 - 18, 0.0f, 0.0f, 18, 18, 18, 18);
        }
        if (((WolfEntityProvider)this.wolf).hasChestEquipped()) {
            if (this.mouseX >= (float)(i + 7) && this.mouseX < (float)(i + 7 + 18) && this.mouseY >= (float)(j + 35) && this.mouseY < (float)(j + 35 + 18)) {
                context.method_25290(class_10799.field_56883, BUTTON_CHEST_HIGHLIGHTED, i + 7, j + 35, 0.0f, 0.0f, 18, 18, 18, 18);
                context.method_51438(this.field_22793, class_2561.method_30163((String)"Drop bag and items"), mouseX, mouseY);
            } else {
                context.method_25290(class_10799.field_56883, BUTTON_CHEST_AVAILABLE, i + 7, j + 35, 0.0f, 0.0f, 18, 18, 18, 18);
            }
        }
        if (this.wolf.method_6181()) {
            if (this.mouseX >= (float)(i + 7) && this.mouseX < (float)(i + 7 + 18) && this.mouseY >= (float)(j + 35 + 18) && this.mouseY < (float)(j + 35 + 36)) {
                context.method_25290(class_10799.field_56883, BUTTON_RELEASE_HIGHLIGHTED, i + 7, j + 35 + 18, 0.0f, 0.0f, 18, 18, 18, 18);
                context.method_51438(this.field_22793, class_2561.method_30163((String)"Release wolf"), mouseX, mouseY);
            } else {
                context.method_25290(class_10799.field_56883, BUTTON_RELEASE_AVAILABLE, i + 7, j + 35 + 18, 0.0f, 0.0f, 18, 18, 18, 18);
            }
        }
        this.method_2380(context, mouseX, mouseY);
        class_490.method_2486((class_332)context, (int)(i + 26), (int)(j + 18), (int)(i + 78), (int)(j + 70), (int)33, (float)0.25f, (float)this.mouseX, (float)this.mouseY, (class_1309)this.wolf);
    }

    private void drawHearts(class_332 context) {
        int WIDTH = 8;
        int HEIGHT = 9;
        int x = this.field_22789 / 2;
        int y = this.field_22790 / 2 - 10 - 9;
        int maxHealthPoints = (int)this.wolf.method_6063() / 4;
        int healthPixels = (int)this.wolf.method_6032() * 2 + 1;
        context.method_25290(class_10799.field_56883, HEART_CONTAINER, x, y, 0.0f, 0.0f, 8 * maxHealthPoints + 1, 9, 8, 9);
        context.method_25290(class_10799.field_56883, HEART, x, y, 0.0f, 0.0f, healthPixels, 9, 8, 9);
    }

    private void drawLevelInfo(class_332 context) {
        int WIDTH = 30;
        int HEIGHT = 5;
        int x = this.field_22789 / 2 + this.field_2792 / 2 - 30 - 7;
        int y = (this.field_22790 - this.field_2779) / 2 + 5 + 3 - 1;
        int xp = this.wolfXp.getXp();
        int level = this.wolfXp.getLevel();
        int maxXp = this.wolfXp.getNextLevelXpRequirement(level + 1);
        int prevMaxXp = this.wolfXp.getNextLevelXpRequirement(level);
        int deltaMaxXp = maxXp - prevMaxXp;
        int deltaXp = xp - prevMaxXp;
        Object xpText = level < 1 ? "" : "" + level;
        int xpTextWidth = this.field_22793.method_1727((String)xpText);
        context.method_25290(class_10799.field_56883, EXPERIENCE_BAR_BACKGROUND_TEXTURE, x, y, 0.0f, 0.0f, 30, 5, 30, 5);
        int currentXpBar = 30 * (deltaXp / deltaMaxXp);
        context.method_25290(class_10799.field_56883, EXPERIENCE_BAR_CURRENT_TEXTURE, x, y, 0.0f, 0.0f, 30 * deltaXp / deltaMaxXp, 5, 30, 5);
        context.method_51433(this.field_22793, (String)xpText, x + 15 - xpTextWidth / 2, y - 4 + 2, -8455136, true);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        super.method_25394(context, mouseX, mouseY, delta);
        this.method_2380(context, mouseX, mouseY);
        this.drawLevelInfo(context);
        this.drawHearts(context);
    }
}

