/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.spyglass_astronomy.commands.admin_subcommands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.nettakrim.spyglass_astronomy.SpaceDataManager;
import com.nettakrim.spyglass_astronomy.SpyglassAstronomyClient;
import com.nettakrim.spyglass_astronomy.commands.admin_subcommands.StarCountCommand;
import com.nettakrim.spyglass_astronomy.mixin.BiomeAccessAccessor;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;

public class SeedCommand {
    public static LiteralCommandNode<FabricClientCommandSource> getCommandNode() {
        LiteralCommandNode seedNode = ClientCommandManager.literal((String)"seed").build();
        LiteralCommandNode starNode = ClientCommandManager.literal((String)"star").build();
        LiteralCommandNode queryStarSeedNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"query").executes(SeedCommand::queryStarSeed)).build();
        LiteralCommandNode resetStarSeedNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"reset").executes(SeedCommand::resetStarSeed)).build();
        LiteralCommandNode setStarSeedNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"seed", (ArgumentType)LongArgumentType.longArg()).executes(SeedCommand::setStarSeed))).build();
        LiteralCommandNode planetNode = ClientCommandManager.literal((String)"planet").build();
        LiteralCommandNode queryPlanetSeedNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"query").executes(SeedCommand::queryPlanetSeed)).build();
        LiteralCommandNode resetPlanetSeedNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"reset").executes(SeedCommand::resetPlanetSeed)).build();
        LiteralCommandNode setPlanetSeedNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"seed", (ArgumentType)LongArgumentType.longArg()).executes(SeedCommand::setPlanetSeed))).build();
        starNode.addChild((CommandNode)queryStarSeedNode);
        starNode.addChild((CommandNode)resetStarSeedNode);
        starNode.addChild((CommandNode)setStarSeedNode);
        seedNode.addChild((CommandNode)starNode);
        planetNode.addChild((CommandNode)queryPlanetSeedNode);
        planetNode.addChild((CommandNode)resetPlanetSeedNode);
        planetNode.addChild((CommandNode)setPlanetSeedNode);
        seedNode.addChild((CommandNode)planetNode);
        return seedNode;
    }

    private static int setStarSeed(CommandContext<FabricClientCommandSource> context) {
        return SeedCommand.setStarSeed(LongArgumentType.getLong(context, (String)"seed"));
    }

    private static int resetStarSeed(CommandContext<FabricClientCommandSource> context) {
        return SeedCommand.setStarSeed(((BiomeAccessAccessor)SpyglassAstronomyClient.world.method_22385()).getSeed());
    }

    private static int queryStarSeed(CommandContext<FabricClientCommandSource> context) {
        SpyglassAstronomyClient.say("commands.admin.seed.star.query", Long.toString(SpyglassAstronomyClient.spaceDataManager.getStarSeed()));
        return 1;
    }

    private static int setStarSeed(long seed) {
        SpyglassAstronomyClient.say("commands.admin.seed.star.set", Long.toString(seed), Long.toString(SpyglassAstronomyClient.spaceDataManager.getStarSeed()));
        SpyglassAstronomyClient.spaceDataManager.setStarSeed(seed);
        SpyglassAstronomyClient.generateStars(null, true, true);
        StarCountCommand.invalidatedConstellations.clear();
        SpaceDataManager.makeChange();
        return 1;
    }

    private static int setPlanetSeed(CommandContext<FabricClientCommandSource> context) {
        return SeedCommand.setPlanetSeed(LongArgumentType.getLong(context, (String)"seed"));
    }

    private static int resetPlanetSeed(CommandContext<FabricClientCommandSource> context) {
        return SeedCommand.setPlanetSeed(((BiomeAccessAccessor)SpyglassAstronomyClient.world.method_22385()).getSeed());
    }

    private static int queryPlanetSeed(CommandContext<FabricClientCommandSource> context) {
        SpyglassAstronomyClient.say("commands.admin.seed.planet.query", Long.toString(SpyglassAstronomyClient.spaceDataManager.getPlanetSeed()));
        return 1;
    }

    private static int setPlanetSeed(long seed) {
        SpyglassAstronomyClient.say("commands.admin.seed.planet.set", Long.toString(seed), Long.toString(SpyglassAstronomyClient.spaceDataManager.getPlanetSeed()));
        SpyglassAstronomyClient.spaceDataManager.setPlanetSeed(seed);
        SpyglassAstronomyClient.generatePlanets(null, true);
        SpaceDataManager.makeChange();
        return 1;
    }
}

