/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.spyglass_astronomy.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.nettakrim.spyglass_astronomy.Constellation;
import com.nettakrim.spyglass_astronomy.OrbitingBody;
import com.nettakrim.spyglass_astronomy.SpyglassAstronomyClient;
import com.nettakrim.spyglass_astronomy.Star;
import com.nettakrim.spyglass_astronomy.commands.SpyglassAstronomyCommands;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2196;

public class SelectCommand {
    public static LiteralCommandNode<FabricClientCommandSource> getCommandNode() {
        LiteralCommandNode selectNode = ClientCommandManager.literal((String)"sga:select").build();
        LiteralCommandNode constellationSelectNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"constellation").then(ClientCommandManager.argument((String)"name", (ArgumentType)class_2196.method_9340()).suggests(SpyglassAstronomyCommands.constellations).executes(SelectCommand::selectConstellation))).build();
        LiteralCommandNode starSelectNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"star").then(ClientCommandManager.argument((String)"name", (ArgumentType)class_2196.method_9340()).suggests(SpyglassAstronomyCommands.stars).executes(SelectCommand::selectStar))).build();
        LiteralCommandNode orbitingBodySelectNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"planet").then(ClientCommandManager.argument((String)"name", (ArgumentType)class_2196.method_9340()).suggests(SpyglassAstronomyCommands.orbitingBodies).executes(SelectCommand::selectOrbitingBody))).build();
        selectNode.addChild((CommandNode)constellationSelectNode);
        selectNode.addChild((CommandNode)starSelectNode);
        selectNode.addChild((CommandNode)orbitingBodySelectNode);
        return selectNode;
    }

    private static int selectConstellation(CommandContext<FabricClientCommandSource> context) {
        Constellation constellation = SpyglassAstronomyCommands.getConstellation(context);
        if (constellation == null) {
            return -1;
        }
        if (!SpyglassAstronomyClient.isHoldingSpyglass()) {
            SpyglassAstronomyClient.say("commands.select.constellation.fail", new Object[0]);
            return -1;
        }
        constellation.select();
        SpyglassAstronomyClient.say("commands.select.constellation", constellation.name);
        return 1;
    }

    private static int selectStar(CommandContext<FabricClientCommandSource> context) {
        Star star = SpyglassAstronomyCommands.getStar(context);
        if (star == null) {
            return -1;
        }
        if (!SpyglassAstronomyClient.isHoldingSpyglass()) {
            SpyglassAstronomyClient.say("commands.select.star.fail", new Object[0]);
            return -1;
        }
        star.select();
        String starName = star.isUnnamed() ? "Unnamed" : star.name;
        SpyglassAstronomyClient.say("commands.select.star", starName);
        return 1;
    }

    private static int selectOrbitingBody(CommandContext<FabricClientCommandSource> context) {
        OrbitingBody orbitingBody = SpyglassAstronomyCommands.getOrbitingBody(context);
        if (orbitingBody == null) {
            return -1;
        }
        if (!SpyglassAstronomyClient.isHoldingSpyglass()) {
            SpyglassAstronomyClient.say("commands.select." + (orbitingBody.isPlanet ? "planet" : "comet") + ".fail", new Object[0]);
            return -1;
        }
        orbitingBody.select();
        String orbitingBodyName = orbitingBody.isUnnamed() ? "Unnamed" : orbitingBody.name;
        SpyglassAstronomyClient.say("commands.select." + (orbitingBody.isPlanet ? "planet" : "comet"), orbitingBodyName);
        return 1;
    }
}

