/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.spyglass_astronomy;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.nettakrim.spyglass_astronomy.Constellation;
import com.nettakrim.spyglass_astronomy.OrbitingBody;
import com.nettakrim.spyglass_astronomy.SpyglassAstronomyClient;
import com.nettakrim.spyglass_astronomy.Star;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.Scanner;
import net.minecraft.class_10799;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class SpaceRenderingManager {
    private final RenderSystem.class_5590 indexBuffer;
    private GpuBuffer starsBuffer;
    private int starsCount = 0;
    private GpuBuffer constellationsBuffer;
    private int constellationsCount = 0;
    private GpuBuffer drawingBuffer;
    private int drawingCount = 0;
    private GpuBuffer planetsBuffer;
    private int planetsCount = 0;
    private static float heightScale = 1.0f;
    public static boolean constellationsVisible;
    public static boolean starsVisible;
    public static boolean orbitingBodiesVisible;
    public static boolean oldStarsVisible;
    public static boolean starsAlwaysVisible;
    private float starVisibility;
    private boolean constellationsNeedsUpdate = true;
    private File data = null;
    private final Path storagePath;
    private final String fileName;
    private static final RenderPipeline pipeline;

    public SpaceRenderingManager() {
        this.storagePath = SpyglassAstronomyClient.client.field_1697.toPath().resolve(".spyglass_astronomy");
        this.fileName = String.valueOf(this.storagePath) + "/rendering.txt";
        constellationsVisible = true;
        starsVisible = true;
        orbitingBodiesVisible = true;
        oldStarsVisible = false;
        starsAlwaysVisible = false;
        if (Files.exists(this.storagePath, new LinkOption[0])) {
            this.data = new File(this.fileName);
            if (this.data.exists()) {
                this.loadData();
            }
        }
        this.indexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
    }

    private void loadData() {
        try {
            if (this.data.createNewFile()) {
                return;
            }
            Scanner scanner = new Scanner(this.data);
            String s = scanner.nextLine();
            scanner.close();
            constellationsVisible = this.charTrue(s, 0);
            starsVisible = this.charTrue(s, 1);
            orbitingBodiesVisible = this.charTrue(s, 2);
            oldStarsVisible = this.charTrue(s, 3);
            starsAlwaysVisible = this.charTrue(s, 4);
        }
        catch (IOException e) {
            SpyglassAstronomyClient.LOGGER.info("Failed to load data");
        }
    }

    private boolean charTrue(String s, int index) {
        return index < s.length() && s.charAt(index) == '1';
    }

    public void saveData() {
        try {
            if (this.data == null) {
                Files.createDirectories(this.storagePath, new FileAttribute[0]);
                this.data = new File(this.fileName);
            }
            FileWriter writer = new FileWriter(this.data);
            String s = (constellationsVisible ? "1" : "0") + (starsVisible ? "1" : "0") + (orbitingBodiesVisible ? "1" : "0") + (oldStarsVisible ? "1" : "0") + (starsAlwaysVisible ? "1" : "0");
            writer.write(s);
            writer.close();
        }
        catch (IOException e) {
            SpyglassAstronomyClient.LOGGER.info("Failed to save data");
        }
    }

    public void updateSpace(int ticks) {
        class_746 player;
        SpaceRenderingManager.updateHeightScale();
        if (!(Constellation.selected == null || (player = SpyglassAstronomyClient.client.field_1724) != null && SpyglassAstronomyClient.isHoldingSpyglass())) {
            Constellation.deselect();
            this.constellationsNeedsUpdate = true;
        }
        if (this.constellationsNeedsUpdate) {
            this.updateConstellations();
            this.constellationsNeedsUpdate = false;
        }
        if (!(Star.selected == null || (player = SpyglassAstronomyClient.client.field_1724) != null && SpyglassAstronomyClient.isHoldingSpyglass())) {
            Star.deselect();
        }
        if (!(OrbitingBody.selected == null || (player = SpyglassAstronomyClient.client.field_1724) != null && SpyglassAstronomyClient.isHoldingSpyglass())) {
            OrbitingBody.deselect();
        }
        this.updateStars(ticks);
        this.updateOrbits(ticks);
    }

    public void scheduleConstellationsUpdate() {
        this.constellationsNeedsUpdate = true;
    }

    public void cancelDrawing() {
        this.drawingCount = 0;
    }

    private void updateConstellations() {
        int n = this.drawingCount = SpyglassAstronomyClient.isDrawingConstellation ? 1 : 0;
        if (SpyglassAstronomyClient.constellations.isEmpty()) {
            this.constellationsCount = 0;
            return;
        }
        class_287 bufferBuilder = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27382, class_290.field_1576);
        for (Constellation constellation : SpyglassAstronomyClient.constellations) {
            constellation.setVertices(bufferBuilder, false);
        }
        class_9801 builtBuffer = bufferBuilder.method_60800();
        if (this.constellationsBuffer != null) {
            this.constellationsBuffer.close();
        }
        this.constellationsBuffer = RenderSystem.getDevice().createBuffer(() -> "SGA Constellations Buffer", 40, builtBuffer.method_60818());
        this.constellationsCount = builtBuffer.method_60822().comp_751();
        builtBuffer.close();
    }

    private void updateStars(int ticks) {
        if (SpyglassAstronomyClient.stars.isEmpty()) {
            this.starsCount = 0;
            return;
        }
        class_287 bufferBuilder = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27382, class_290.field_1576);
        for (Star star : SpyglassAstronomyClient.stars) {
            star.update(ticks);
            star.setVertices(bufferBuilder);
        }
        if (this.starsBuffer != null) {
            this.starsBuffer.close();
        }
        class_9801 builtBuffer = bufferBuilder.method_60800();
        this.starsBuffer = RenderSystem.getDevice().createBuffer(() -> "SGA Stars Buffer", 40, builtBuffer.method_60818());
        this.starsCount = builtBuffer.method_60822().comp_751();
        builtBuffer.close();
    }

    private void updateOrbits(int ticks) {
        if (SpyglassAstronomyClient.orbitingBodies.isEmpty()) {
            orbitingBodiesVisible = false;
            return;
        }
        class_287 bufferBuilder = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27382, class_290.field_1576);
        Long day = SpyglassAstronomyClient.getDay();
        float dayFraction = SpyglassAstronomyClient.getDayFraction();
        Vector3f referencePosition = SpyglassAstronomyClient.earthOrbit.getRotatedPositionAtGlobalTime(day, dayFraction, true);
        Vector3f normalisedReferencePosition = new Vector3f((Vector3fc)referencePosition);
        normalisedReferencePosition.normalize();
        for (OrbitingBody orbitingBody : SpyglassAstronomyClient.orbitingBodies) {
            orbitingBody.update(ticks, referencePosition, normalisedReferencePosition, day, dayFraction);
            orbitingBody.setVertices(bufferBuilder);
        }
        class_9801 builtBuffer = bufferBuilder.method_60800();
        if (this.planetsBuffer != null) {
            this.planetsBuffer.close();
        }
        this.planetsBuffer = RenderSystem.getDevice().createBuffer(() -> "SGA Planets Buffer", 40, builtBuffer.method_60818());
        this.planetsCount = builtBuffer.method_60822().comp_751();
        builtBuffer.close();
    }

    private void updateDrawingConstellation() {
        class_287 bufferBuilder = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27382, class_290.field_1576);
        SpyglassAstronomyClient.drawingConstellation.setVertices(bufferBuilder, true);
        class_9801 builtBuffer = bufferBuilder.method_60800();
        if (this.drawingBuffer != null) {
            this.drawingBuffer.close();
        }
        this.drawingBuffer = RenderSystem.getDevice().createBuffer(() -> "SGA Drawing Buffer", 40, builtBuffer.method_60818());
        this.drawingCount = builtBuffer.method_60822().comp_751();
        builtBuffer.close();
    }

    public void render(class_4587 matrices, float tickDelta) {
        float f = this.starVisibility = starsAlwaysVisible ? 1.0f : SpyglassAstronomyClient.world.method_23787(tickDelta) * (1.0f - SpyglassAstronomyClient.world.method_8430(tickDelta));
        if (this.starVisibility > 0.0f) {
            RenderPass renderPass;
            GpuBufferSlice gpuBufferSlice;
            float colorScale = this.starVisibility + Math.min(heightScale, 0.5f);
            if (constellationsVisible && SpyglassAstronomyClient.isDrawingConstellation || this.drawingCount > 0) {
                this.updateDrawingConstellation();
            }
            GpuTextureView mainColor = class_310.method_1551().method_1522().method_71639();
            GpuTextureView mainDepth = class_310.method_1551().method_1522().method_71640();
            Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
            if (starsVisible || constellationsVisible) {
                matrices.method_22903();
                matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-90.0f));
                matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(SpyglassAstronomyClient.getStarAngle()));
                matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(45.0f));
                matrix4fStack.pushMatrix();
                matrix4fStack.mul((Matrix4fc)matrices.method_23760().method_23761());
                gpuBufferSlice = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)matrix4fStack, (Vector4fc)new Vector4f(colorScale, colorScale, colorScale, this.starVisibility), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
                renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Stars", mainColor, OptionalInt.empty(), mainDepth, OptionalDouble.empty());
                renderPass.setUniform("DynamicTransforms", gpuBufferSlice);
                try {
                    renderPass.setPipeline(pipeline);
                    if (starsVisible) {
                        this.draw(renderPass, this.starsBuffer, this.starsCount);
                    }
                    if (constellationsVisible) {
                        this.draw(renderPass, this.constellationsBuffer, this.constellationsCount);
                        if (SpyglassAstronomyClient.isDrawingConstellation) {
                            this.draw(renderPass, this.drawingBuffer, this.drawingCount);
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                renderPass.close();
                matrices.method_22909();
                matrix4fStack.popMatrix();
            }
            if (orbitingBodiesVisible && this.planetsCount > 0) {
                matrices.method_22903();
                matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(SpyglassAstronomyClient.getPositionInOrbit(360.0f) * (1.0f - 1.0f / SpyglassAstronomyClient.earthOrbit.period) + 180.0f));
                matrix4fStack.pushMatrix();
                matrix4fStack.mul((Matrix4fc)matrices.method_23760().method_23761());
                gpuBufferSlice = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)matrix4fStack, (Vector4fc)new Vector4f(colorScale, colorScale, colorScale, this.starVisibility), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
                renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Planets", mainColor, OptionalInt.empty(), mainDepth, OptionalDouble.empty());
                renderPass.setUniform("DynamicTransforms", gpuBufferSlice);
                try {
                    renderPass.setPipeline(pipeline);
                    this.draw(renderPass, this.planetsBuffer, this.planetsCount);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                renderPass.close();
                matrices.method_22909();
                matrix4fStack.popMatrix();
            }
        }
    }

    public static void assignIrisPipeline() {
        try {
            String irisApiPackage = "net.irisshaders.iris.api.v0.";
            Class<?> irisApiClass = Class.forName(irisApiPackage + "IrisApi");
            Object INSTANCE = irisApiClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Class<?> irisProgramClass = Class.forName(irisApiPackage + "IrisProgram");
            Enum SKY_BASIC = Enum.valueOf(irisProgramClass.asSubclass(Enum.class), "SKY_BASIC");
            Method assignPipeline = irisApiClass.getMethod("assignPipeline", RenderPipeline.class, irisProgramClass);
            assignPipeline.invoke(INSTANCE, pipeline, SKY_BASIC);
        }
        catch (Exception ignored) {
            SpyglassAstronomyClient.LOGGER.error("Failed to assign pipeline. Shader compatibility may be broken");
        }
    }

    public static void updateHeightScale() {
        heightScale = class_3532.method_15363((float)((SpyglassAstronomyClient.getHeight() - 32.0f) / 256.0f), (float)0.0f, (float)1.0f);
    }

    public static float getHeightScale() {
        return heightScale;
    }

    public boolean starsCurrentlyVisible() {
        return this.starVisibility > 0.0f;
    }

    private void draw(RenderPass renderPass, GpuBuffer gpuBuffer, int count) {
        if (count == 0) {
            return;
        }
        renderPass.setVertexBuffer(0, gpuBuffer);
        renderPass.setIndexBuffer(this.indexBuffer.method_68274(count), this.indexBuffer.method_31924());
        renderPass.drawIndexed(0, 0, count, 1);
    }

    static {
        pipeline = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56860}).withLocation("pipeline/sga_stars").withVertexShader("core/position_color").withFragmentShader("core/position_color").withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27382).withBlend(BlendFunction.OVERLAY).withDepthWrite(false).build();
    }
}

