/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.resource;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import dev.lambdaurora.lambdabettergrass.metadata.LBGState;
import dev.lambdaurora.lambdabettergrass.resource.LBGLayerTypeManager;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7923;
import org.slf4j.Logger;

public class LBGResourceReloader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final LBGLayerTypeManager layerTypeManager;

    public LBGResourceReloader(LBGLayerTypeManager layerTypeManager) {
        this.layerTypeManager = layerTypeManager;
    }

    public void reload(class_3300 resourceManager) {
        LBGState.reset();
        this.layerTypeManager.load(resourceManager);
        this.loadStates(resourceManager);
    }

    private void loadStates(class_3300 resourceManager) {
        resourceManager.method_14488("bettergrass/states", id -> id.method_12832().endsWith(".json")).forEach((id, resource) -> this.loadState(resourceManager, (class_2960)id, (class_3298)resource));
    }

    private void loadState(class_3300 resourceManager, class_2960 id, class_3298 resource) {
        class_2960 stateId = class_2960.method_60655((String)id.method_12836(), (String)id.method_12832().substring("bettergrass/states".length() + 1, id.method_12832().length() - ".json".length()));
        Optional block = class_7923.field_41175.method_17966(stateId);
        if (block.isEmpty()) {
            return;
        }
        try (InputStreamReader reader = new InputStreamReader(resource.method_14482());){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            LBGState.loadMetadataState(stateId, resourceManager, json, (class_2689<class_2248, class_2680>)((class_2248)block.get()).method_9595());
        }
        catch (IOException e) {
            LOGGER.warn("Failed to load LambdaBetterGrass state {}.", (Object)stateId, (Object)e);
        }
    }
}

