/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPosMutable;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.util.FullDataPointUtil;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import net.minecraft.class_1920;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_6539;
import net.minecraft.class_6880;

public abstract class AbstractDhTintGetter
implements class_1920 {
    protected final BiomeWrapper biomeWrapper;
    protected final int smoothingRadiusInBlocks;
    protected final FullDataSourceV2 fullDataSource;

    public AbstractDhTintGetter(BiomeWrapper biomeWrapper, FullDataSourceV2 fullDataSource) {
        this.biomeWrapper = biomeWrapper;
        this.fullDataSource = fullDataSource;
        this.smoothingRadiusInBlocks = Config.Client.Advanced.Graphics.Quality.lodBiomeBlending.get();
    }

    public int method_23752(class_2338 blockPos, class_6539 colorResolver) {
        byte dataSourceDetailLevel = DhSectionPos.getDetailLevel(this.fullDataSource.getPos());
        dataSourceDetailLevel = (byte)(dataSourceDetailLevel - 6);
        int dataSourceLodWidthInBlocks = DhSectionPos.getDetailLevelWidthInBlocks(dataSourceDetailLevel);
        if (this.smoothingRadiusInBlocks == 0 || dataSourceLodWidthInBlocks > this.smoothingRadiusInBlocks) {
            return colorResolver.getColor(this.unwrapBiome(this.biomeWrapper.biome), (double)blockPos.method_10263(), (double)blockPos.method_10260());
        }
        int dataPointCount = 0;
        int rollingRed = 0;
        int rollingGreen = 0;
        int rollingBlue = 0;
        int xMin = blockPos.method_10263() - this.smoothingRadiusInBlocks;
        int xMax = blockPos.method_10263() + this.smoothingRadiusInBlocks;
        int zMin = blockPos.method_10260() - this.smoothingRadiusInBlocks;
        int zMax = blockPos.method_10260() + this.smoothingRadiusInBlocks;
        DhBlockPosMutable mutableBlockPos = new DhBlockPosMutable(0, blockPos.method_10264(), 0);
        for (int x = xMin; x < xMax; ++x) {
            for (int z = zMin; z < zMax; ++z) {
                mutableBlockPos.setX(x);
                mutableBlockPos.setZ(z);
                long dataPoint = this.fullDataSource.getAtBlockPos(mutableBlockPos);
                if (dataPoint == 0L) continue;
                int id = FullDataPointUtil.getId(dataPoint);
                BiomeWrapper biomeWrapper = (BiomeWrapper)this.fullDataSource.mapping.getBiomeWrapper(id);
                int color = colorResolver.getColor(this.unwrapBiome(biomeWrapper.biome), (double)mutableBlockPos.getX(), (double)mutableBlockPos.getZ());
                rollingRed += ColorUtil.getRed(color);
                rollingGreen += ColorUtil.getGreen(color);
                rollingBlue += ColorUtil.getBlue(color);
                ++dataPointCount;
            }
        }
        if (dataPointCount == 0) {
            return colorResolver.getColor(this.unwrapBiome(this.biomeWrapper.biome), (double)blockPos.method_10263(), (double)blockPos.method_10260());
        }
        int colorInt = ColorUtil.argbToInt(255, rollingRed / dataPointCount, rollingGreen / dataPointCount, rollingBlue / dataPointCount);
        return colorInt;
    }

    protected class_1959 unwrapBiome(class_6880<class_1959> biome) {
        return (class_1959)biome.comp_349();
    }
}

