/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.util;

import java.util.Set;
import journeymap.api.services.Services;
import journeymap.client.Constants;
import journeymap.common.CommonConstants;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.network.model.Location;
import journeymap.common.properties.DimensionProperties;
import journeymap.common.properties.PropertiesManager;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.server.MinecraftServer;

public class JourneyMapTeleport {
    private static final JourneyMapTeleport INSTANCE = new JourneyMapTeleport();

    private JourneyMapTeleport() {
    }

    public static JourneyMapTeleport instance() {
        return INSTANCE;
    }

    public boolean attemptTeleport(class_1297 entity, Location location) {
        MinecraftServer mcServer = Services.COMMON_SERVICE.getServer();
        boolean creative = false;
        boolean cheatMode = false;
        if (entity == null) {
            Journeymap.getLogger().error("Attempted to teleport null entity.");
            return false;
        }
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            creative = serverPlayer.method_31549().field_7477;
            boolean bl = cheatMode = mcServer.method_3760().method_14569(serverPlayer.method_7334()) && Services.COMMON_SERVICE.isClient();
            if (mcServer == null) {
                serverPlayer.method_64398((class_2561)Constants.getStringTextComponent("Cannot Find World"));
                return false;
            }
            if (this.isTeleportAvailable((class_1297)serverPlayer, location) || creative || cheatMode || Services.COMMON_SERVICE.isOp((class_1657)serverPlayer) && (mcServer.method_3835(serverPlayer.method_7334()) >= 2 || CommonConstants.debugOverride((class_1297)serverPlayer))) {
                if (!serverPlayer.method_5805()) {
                    serverPlayer.method_64398((class_2561)Constants.getStringTextComponent("Cannot teleport when dead."));
                    return false;
                }
                class_3218 destinationWorld = mcServer.method_3847(DimensionHelper.getWorldKeyForName(location.getDim()));
                if (destinationWorld == null) {
                    for (class_3218 world : mcServer.method_3738()) {
                        if (!location.getDim().equalsIgnoreCase(DimensionHelper.getDimName((class_1937)world)) && !location.getDim().equalsIgnoreCase(DimensionHelper.getDimKeyName((class_5321<class_1937>)world.method_27983()))) continue;
                        destinationWorld = world;
                        break;
                    }
                }
                if (destinationWorld == null) {
                    serverPlayer.method_64398((class_2561)Constants.getStringTextComponent("Could not get world for Dimension " + location.getDim()));
                    return false;
                }
                return this.teleportEntity(destinationWorld, entity, location);
            }
            serverPlayer.method_64398((class_2561)Constants.getStringTextComponent("Server has disabled JourneyMap teleport usage for your current or destination dimension."));
            return false;
        }
        return false;
    }

    private boolean isTeleportAvailable(class_1297 entity, Location location) {
        DimensionProperties destinationProperty = PropertiesManager.getInstance().getDimProperties(DimensionHelper.getWorldKeyForName(location.getDim()));
        DimensionProperties entityLocationProperty = PropertiesManager.getInstance().getDimProperties(DimensionHelper.getDimension(entity));
        return this.canDimTeleport(destinationProperty) && this.canDimTeleport(entityLocationProperty);
    }

    private boolean canDimTeleport(DimensionProperties properties) {
        if (properties.enabled.get().booleanValue()) {
            return properties.teleportEnabled.get();
        }
        return PropertiesManager.getInstance().getGlobalProperties().teleportEnabled.get();
    }

    private boolean teleportEntity(class_3218 destinationWorld, class_1297 player, Location location) {
        boolean changedWorld;
        class_3218 startWorld = (class_3218)player.method_37908();
        boolean bl = changedWorld = startWorld != destinationWorld;
        if (player instanceof class_3222) {
            boolean crossDimTpAllow;
            class_3222 serverPlayer = (class_3222)player;
            boolean bl2 = crossDimTpAllow = PropertiesManager.getInstance().getGlobalProperties().crossDimTeleport.get() != false || Services.COMMON_SERVICE.isOp((class_1657)((class_3222)player));
            if (changedWorld) {
                if (crossDimTpAllow) {
                    class_5454 transition = new class_5454(destinationWorld, new class_243(location.getX() + 0.5, location.getY() + 0.5, location.getZ() + 0.5), class_243.field_1353, 0.0f, 0.0f, Set.of(), class_5454.field_52245);
                    serverPlayer.method_61275(transition);
                } else {
                    serverPlayer.method_64398((class_2561)Constants.getStringTextComponent("Server disabled cross dimension teleport."));
                }
            } else {
                class_5454 transition = new class_5454(serverPlayer.method_51469(), new class_243(location.getX(), location.getY(), location.getZ()), class_243.field_1353, 0.0f, 0.0f, Set.of(), class_5454.field_52245);
                serverPlayer.method_61275(transition);
            }
            if (!CommonConstants.debugOverride((class_1297)serverPlayer)) {
                Journeymap.getLogger().info("{} teleported to {} {} {} {}", (Object)serverPlayer.method_5477().getString(), (Object)location.getX(), (Object)location.getY(), (Object)location.getZ(), (Object)location.getDim());
            }
        }
        return false;
    }
}

