/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.properties.config.custom;

import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.model.map.MapType;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.ui.option.MapTypeProvider;
import journeymap.common.properties.catagory.Category;
import journeymap.common.properties.config.IntegerField;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class MinimapCaveLayerIntField
extends IntegerField {
    private static final String ATTR_PARENT_ID = "minimap_properties_id";

    public MinimapCaveLayerIntField(Category category, String key, int minValue, int maxValue, int defaultValue, int minimapId, int sortOrder) {
        super(category, key, minValue, maxValue, defaultValue, 100);
        this.put(ATTR_PARENT_ID, minimapId);
        this.put("enabled", true);
        this.sortOrder(sortOrder);
    }

    @Override
    public String getTooltip() {
        int slice = this.get();
        int minY = slice << 4;
        int maxY = (slice + 1 << 4) - 1;
        return Constants.getString("jm.fullscreen.map_cave_layers.button.tooltip", minY, maxY);
    }

    public void updateSlices() {
        class_638 world = class_310.method_1551().field_1687;
        if (world != null && world.method_8597().comp_653() != 256 && this.getMaxValue() != world.method_8597().comp_653() / 16 - 1) {
            int maxSlice = world.method_8597().comp_653() / 16 - 1;
            int minSlice = world.method_8597().comp_651() / 16;
            int seaLevel = Math.round(world.method_8615() >> 4);
            this.range(minSlice, maxSlice);
            this.defaultValue(seaLevel);
        }
    }

    public void setId(int minimapId) {
        this.put(ATTR_PARENT_ID, minimapId);
    }

    @Override
    public boolean isEnabled() {
        this.updateSlices();
        MiniMapProperties prop = JourneymapClient.getInstance().getMiniMapProperties(this.getIntegerAttr(ATTR_PARENT_ID));
        if (prop != null) {
            this.put("enabled", prop.minimapLockedMapType.get().equals(MapTypeProvider.from(MapType.Name.underground)) && prop.enabled.get() != false);
        }
        return this.getBooleanAttr("enabled");
    }
}

