/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_7923;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.TraceableException;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.impl.ui.TextElementImpl;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.util.ModIdentification;
import snownee.jade.util.WailaExceptionHandler;

public class ItemTooltipProvider
implements IEntityComponentProvider {
    public static final ItemTooltipProvider INSTANCE = new ItemTooltipProvider();

    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        class_1799 stack = ((class_1542)accessor.getEntity()).method_6983();
        class_1792.class_9635 tooltipContext = class_1792.class_9635.method_59528((class_1937)accessor.getLevel());
        ArrayList lines = Lists.newArrayList();
        try {
            stack.method_7950(tooltipContext, null, (class_1836)class_1836.class_1837.field_41070).stream().peek(component -> {
                class_5250 mutable;
                if (component instanceof class_5250 && (mutable = (class_5250)component).method_10866().method_10973() != null) {
                    mutable.method_10862(mutable.method_10866().method_27703((class_5251)null));
                }
            }).map(Either::left).forEach(lines::add);
        }
        catch (Throwable e) {
            String namespace = class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12836();
            WailaExceptionHandler.handleErr(TraceableException.create(e, namespace), this, tooltip::add);
        }
        if (lines.isEmpty()) {
            return;
        }
        List<class_5348> realLines = lines.stream().map($ -> $.left()).filter(Optional::isPresent).map(Optional::get).skip(1L).toList();
        String modName = ModIdentification.getModName(stack);
        class_327 font = DisplayHelper.font();
        int maxWidth = 250;
        for (class_5348 text : realLines) {
            if (Objects.equals(class_124.method_539((String)text.getString()), modName)) continue;
            int width = font.method_27525(text);
            if (width > maxWidth) {
                tooltip.add((class_2561)class_2561.method_43470((String)(font.method_1714(text, maxWidth - 5).getString() + "..")));
                continue;
            }
            tooltip.add(new TextElementImpl(text));
        }
    }

    @Override
    public class_2960 getUid() {
        return JadeIds.MC_ITEM_TOOLTIP;
    }
}

