/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.impl.client.config;

import com.google.common.collect.ImmutableSet;
import fuzs.puzzleslib.api.core.v1.ModContainer;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import java.util.Collection;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4667;
import net.minecraft.class_5250;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.config.ModConfigs;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.common.ModConfigSpec;

public class MultiConfigurationScreen
extends class_4667 {
    private static final String LANG_PREFIX = "neoforge.configuration.uitext.";
    private static final String SECTION = "neoforge.configuration.uitext.section";
    private static final String FILENAME_TOOLTIP = "neoforge.configuration.uitext.filenametooltip";
    protected final Collection<String> modIds;
    protected final ConfigurationScreen configurationScreen;

    public static BiFunction<String, class_437, class_437> getScreenFactory(String[] mergedModIds) {
        return (modId, lastScreen) -> {
            ConfigurationScreen configurationScreen = new ConfigurationScreen(modId, lastScreen, (configurationScreenX, type, modConfig, component) -> new ConfigurationScreen.ConfigurationSectionScreen((class_437)configurationScreenX, ModConfig.Type.COMMON, modConfig, component));
            return new MultiConfigurationScreen((Collection<String>)ImmutableSet.builder().add(modId).add((Object[])mergedModIds).build(), (class_437)lastScreen, configurationScreen);
        };
    }

    MultiConfigurationScreen(Collection<String> modIds, class_437 lastScreen, ConfigurationScreen configurationScreen) {
        super(lastScreen, class_310.method_1551().field_1690, configurationScreen.method_25440());
        this.modIds = modIds;
        this.configurationScreen = configurationScreen;
    }

    protected void method_25426() {
        super.method_25426();
        this.configurationScreen.method_25423(this.field_22787, this.field_22789, this.field_22790);
    }

    protected void method_60325() {
        for (ModConfig.Type type : ModConfig.Type.values()) {
            boolean headerAdded = false;
            for (ModConfig modConfig : ModConfigs.getConfigSet((ModConfig.Type)type)) {
                if (!this.modIds.contains(modConfig.getModId())) continue;
                if (!headerAdded) {
                    this.field_51824.method_20407((class_339)new class_7842(310, 20, (class_2561)class_2561.method_43471((String)(LANG_PREFIX + type.name().toLowerCase(Locale.ENGLISH))).method_27692(class_124.field_1073), this.field_22793).method_48596(), null);
                    headerAdded = true;
                }
                class_4185 btn = class_4185.method_46430((class_2561)class_2561.method_43469((String)SECTION, (Object[])new Object[]{this.translatableConfig(modConfig, "", "neoforge.configuration.uitext.type." + modConfig.getType().name().toLowerCase(Locale.ROOT))}), button -> {
                    class_2561 component = this.translatableConfig(modConfig, ".title", "neoforge.configuration.uitext.title." + type.name().toLowerCase(Locale.ROOT));
                    this.field_22787.method_1507((class_437)new MultiConfigurationSectionScreen((class_437)this, type, modConfig, component, restartType -> {
                        this.configurationScreen.needsRestart = this.configurationScreen.needsRestart.with(restartType);
                    }));
                }).method_46432(310).method_46431();
                class_5250 tooltip = class_2561.method_43473();
                if (!((ModConfigSpec)modConfig.getSpec()).isLoaded()) {
                    tooltip.method_10852(ConfigurationScreen.TOOLTIP_CANNOT_EDIT_NOT_LOADED).method_10852((class_2561)class_2561.method_43470((String)"\n\n"));
                    btn.field_22763 = false;
                } else if (type == ModConfig.Type.SERVER && this.field_22787.method_1558() != null && !this.field_22787.method_47392()) {
                    tooltip.method_10852(ConfigurationScreen.TOOLTIP_CANNOT_EDIT_THIS_WHILE_ONLINE).method_10852((class_2561)class_2561.method_43470((String)"\n\n"));
                    btn.field_22763 = false;
                } else if (type == ModConfig.Type.SERVER && this.field_22787.method_1496() && this.field_22787.method_1576().method_3860()) {
                    tooltip.method_10852(ConfigurationScreen.TOOLTIP_CANNOT_EDIT_THIS_WHILE_OPEN_TO_LAN).method_10852((class_2561)class_2561.method_43470((String)"\n\n"));
                    btn.field_22763 = false;
                }
                tooltip.method_10852((class_2561)class_2561.method_43469((String)FILENAME_TOOLTIP, (Object[])new Object[]{modConfig.getFileName()}));
                btn.method_47400(class_7919.method_47407((class_2561)tooltip));
                this.field_51824.method_20407((class_339)btn, null);
            }
        }
    }

    public class_2561 translatableConfig(ModConfig modConfig, String suffix, String fallback) {
        String fileName = modConfig.getFileName().replaceAll("[^a-zA-Z0-9]+", ".").replaceFirst("^\\.", "").replaceFirst("\\.$", "").toLowerCase(Locale.ENGLISH);
        String translationKey = modConfig.getModId() + ".configuration.section." + fileName + suffix;
        String modName = ModLoaderEnvironment.INSTANCE.getModContainer(modConfig.getModId()).map(ModContainer::getDisplayName).orElse(modConfig.getModId());
        return class_2561.method_43469((String)(class_1074.method_4663((String)translationKey) ? translationKey : fallback), (Object[])new Object[]{modName});
    }

    public void method_25419() {
        this.configurationScreen.method_25419();
    }

    public static class MultiConfigurationSectionScreen
    extends ConfigurationScreen.ConfigurationSectionScreen {
        private final Consumer<ModConfigSpec.RestartType> needsRestartCallback;

        public MultiConfigurationSectionScreen(class_437 parent, ModConfig.Type type, ModConfig modConfig, class_2561 title, Consumer<ModConfigSpec.RestartType> needsRestartCallback) {
            super(parent, type, modConfig, title);
            this.needsRestartCallback = needsRestartCallback;
            this.needsRestart = ModConfigSpec.RestartType.NONE;
        }

        public void method_25419() {
            if (this.changed) {
                this.needsRestartCallback.accept(this.needsRestart);
            }
            super.method_25419();
        }
    }
}

