/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.network.v4;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3898;
import net.minecraft.class_5629;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface PlayerSet {
    public void apply(Consumer<class_3222> var1);

    public static PlayerSet ofNone() {
        return serverPlayerConsumer -> {};
    }

    public static PlayerSet ofEntity(class_1297 entity) {
        PlayerSet playerSet;
        Objects.requireNonNull(entity, "entity is null");
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            playerSet = PlayerSet.ofPlayer(serverPlayer);
        } else {
            playerSet = PlayerSet.ofNone();
        }
        return playerSet;
    }

    public static PlayerSet ofPlayer(class_3222 serverPlayer) {
        Objects.requireNonNull(serverPlayer, "server player is null");
        return serverPlayerConsumer -> serverPlayerConsumer.accept(serverPlayer);
    }

    public static PlayerSet ofOthers(class_3222 serverPlayer) {
        Objects.requireNonNull(serverPlayer, "server player is null");
        return serverPlayerConsumer -> serverPlayer.method_5682().method_3760().method_14571().forEach(currentServerPlayer -> {
            if (currentServerPlayer != serverPlayer) {
                PlayerSet.ofPlayer(currentServerPlayer).apply(serverPlayerConsumer);
            }
        });
    }

    public static PlayerSet ofAll(MinecraftServer minecraftServer) {
        return serverPlayerConsumer -> minecraftServer.method_3760().method_14571().forEach(serverPlayer -> PlayerSet.ofPlayer(serverPlayer).apply(serverPlayerConsumer));
    }

    public static PlayerSet inLevel(class_3218 serverLevel) {
        Objects.requireNonNull(serverLevel, "server level is null");
        return serverPlayerConsumer -> {
            for (class_3222 serverPlayer : serverLevel.method_18456()) {
                PlayerSet.ofPlayer(serverPlayer).apply(serverPlayerConsumer);
            }
        };
    }

    public static PlayerSet nearPosition(class_2382 position, class_3218 serverLevel) {
        Objects.requireNonNull(position, "position is null");
        return PlayerSet.nearPosition(position.method_10263(), position.method_10264(), position.method_10260(), serverLevel);
    }

    public static PlayerSet nearPosition(double posX, double posY, double posZ, class_3218 serverLevel) {
        return PlayerSet.nearPosition(null, posX, posY, posZ, 64.0, serverLevel);
    }

    public static PlayerSet nearPosition(@Nullable class_3222 excludePlayer, double posX, double posY, double posZ, double distance, class_3218 serverLevel) {
        Objects.requireNonNull(serverLevel, "server level is null");
        return serverPlayerConsumer -> {
            for (class_3222 serverPlayer : serverLevel.method_8503().method_3760().method_14571()) {
                double deltaZ;
                double deltaY;
                double deltaX;
                if (serverPlayer == excludePlayer || serverPlayer.method_51469().method_27983() != serverLevel.method_27983() || !((deltaX = posX - serverPlayer.method_23317()) * deltaX + (deltaY = posY - serverPlayer.method_23318()) * deltaY + (deltaZ = posZ - serverPlayer.method_23321()) * deltaZ < distance * distance)) continue;
                PlayerSet.ofPlayer(serverPlayer).apply(serverPlayerConsumer);
            }
        };
    }

    public static PlayerSet nearBlockEntity(class_2586 blockEntity) {
        Objects.requireNonNull(blockEntity, "block entity is null");
        class_1937 level = blockEntity.method_10997();
        Objects.requireNonNull(level, "block entity level is null");
        return level.field_9236 ? PlayerSet.ofNone() : PlayerSet.nearPosition((class_2382)blockEntity.method_11016(), (class_3218)level);
    }

    public static PlayerSet nearChunk(class_2818 levelChunk) {
        Objects.requireNonNull(levelChunk, "chunk is null");
        return levelChunk.method_12200().field_9236 ? PlayerSet.ofNone() : PlayerSet.nearChunk((class_3218)levelChunk.method_12200(), levelChunk.method_12004());
    }

    public static PlayerSet nearChunk(class_3218 serverLevel, class_1923 chunkPos) {
        Objects.requireNonNull(serverLevel, "server level is null");
        Objects.requireNonNull(chunkPos, "chunk pos is null");
        return serverPlayerConsumer -> serverLevel.method_14178().field_17254.method_17210(chunkPos, false).forEach(serverPlayer -> PlayerSet.ofPlayer(serverPlayer).apply(serverPlayerConsumer));
    }

    public static PlayerSet nearEntity(class_1297 entity) {
        Objects.requireNonNull(entity, "entity is null");
        return entity.method_37908().field_9236 ? PlayerSet.ofNone() : serverPlayerConsumer -> {
            class_3898 chunkMap = ((class_3218)entity.method_37908()).method_14178().field_17254;
            class_3898.class_3208 trackedEntity = (class_3898.class_3208)chunkMap.field_18242.get(entity.method_5628());
            if (trackedEntity != null) {
                for (class_5629 serverPlayerConnection : trackedEntity.field_18250) {
                    PlayerSet.ofPlayer(serverPlayerConnection.method_32311()).apply(serverPlayerConsumer);
                }
                if (entity instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)entity;
                    PlayerSet.ofPlayer(serverPlayer).apply(serverPlayerConsumer);
                }
            }
        };
    }

    public static PlayerSet nearPlayer(class_3222 serverPlayer) {
        Objects.requireNonNull(serverPlayer, "server player is null");
        return serverPlayerConsumer -> {
            class_3898 chunkMap = serverPlayer.method_51469().method_14178().field_17254;
            class_3898.class_3208 trackedEntity = (class_3898.class_3208)chunkMap.field_18242.get(serverPlayer.method_5628());
            if (trackedEntity != null) {
                for (class_5629 serverPlayerConnection : trackedEntity.field_18250) {
                    PlayerSet.ofPlayer(serverPlayerConnection.method_32311()).apply(serverPlayerConsumer);
                }
            }
        };
    }
}

