/*
 * Decompiled with CFR 0.152.
 */
package com.adamcalculator.cheststofox;

import com.adamcalculator.cheststofox.util.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class Config {
    public static Config CONFIG;
    @SerializedName(value="version")
    public int version = 1;
    @SerializedName(value="saving")
    public boolean savingEnable = false;
    @SerializedName(value="auto_close_guis")
    public boolean autoCloseWhenSaving = false;
    @SerializedName(value="auto_close_delay")
    public int autoCloseWhenSavingDelay = 200;
    @SerializedName(value="work_dir")
    public String workdir = "%MINECRAFT%/config/cheststofox";

    public boolean isSaving() {
        return this.savingEnable;
    }

    public void setSaving(boolean b) {
        this.savingEnable = b;
        this.save();
    }

    public void setAutoClose(boolean b) {
        this.autoCloseWhenSaving = b;
        this.save();
    }

    public void save() {
        File file = Config.getConfigFile();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((Object)this, Config.class);
        Files.writeFile(file, json);
    }

    public static Config loadFromFile() {
        File file = Config.getConfigFile();
        if (file.exists()) {
            try {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                return (Config)gson.fromJson(Files.readFile(file), Config.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Config();
    }

    public static File getConfigFile() {
        return new File(class_310.method_1551().field_1697, "/config/cheststofox.json");
    }

    public boolean isAutoCloseGuis() {
        return this.autoCloseWhenSaving;
    }
}

