/*
 * Decompiled with CFR 0.152.
 */
package dev.hephaestus.atmosfera.client.sound.modifiers.implementations;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.hephaestus.atmosfera.client.sound.modifiers.AtmosphericSoundModifier;
import dev.hephaestus.atmosfera.world.context.EnvironmentContext;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public record PercentBlockModifier(float lowerVolumeSlider, float upperVolumeSlider, float min, float max, ImmutableCollection<class_2248> blocks, ImmutableCollection<class_6862<class_2248>> blockTags) implements AtmosphericSoundModifier,
AtmosphericSoundModifier.Factory
{
    public PercentBlockModifier(float lowerVolumeSlider, float upperVolumeSlider, float min, float max, ImmutableCollection<class_2248> blocks, ImmutableCollection<class_6862<class_2248>> blockTags) {
        ImmutableList.Builder blocksBuilder = ImmutableList.builder();
        block0: for (class_2248 block : blocks) {
            for (class_6862 tag : blockTags) {
                if (!block.method_9564().method_26164(tag)) continue;
                continue block0;
            }
            blocksBuilder.add((Object)block);
        }
        this.blocks = blocksBuilder.build();
        this.blockTags = blockTags;
        this.lowerVolumeSlider = lowerVolumeSlider;
        this.upperVolumeSlider = upperVolumeSlider;
        this.min = min;
        this.max = max;
    }

    @Override
    public float getModifier(EnvironmentContext context) {
        float modifier = 0.0f;
        for (class_2248 block : this.blocks) {
            modifier += context.getBlockTypePercentage(block);
        }
        for (class_6862 tag : this.blockTags) {
            modifier += context.getBlockTagPercentage((class_6862<class_2248>)tag);
        }
        return modifier >= this.lowerVolumeSlider && modifier >= this.min && modifier <= this.max ? (modifier - this.lowerVolumeSlider) * (1.0f / (this.upperVolumeSlider - this.lowerVolumeSlider)) : 0.0f;
    }

    public static PercentBlockModifier create(JsonObject object) {
        ImmutableList.Builder blocks = ImmutableList.builder();
        ImmutableList.Builder tags = ImmutableList.builder();
        class_3518.method_15261((JsonObject)object, (String)"blocks").forEach(arg_0 -> PercentBlockModifier.lambda$create$0((ImmutableCollection.Builder)tags, (ImmutableCollection.Builder)blocks, arg_0));
        float lowerVolumeSlider = 0.0f;
        float upperVolumeSlider = 1.0f;
        if (object.has("range")) {
            JsonArray array = object.getAsJsonArray("range");
            lowerVolumeSlider = array.get(0).getAsFloat();
            upperVolumeSlider = array.get(1).getAsFloat();
        }
        float min = object.has("min") ? object.get("min").getAsFloat() : -3.4028235E38f;
        float max = object.has("max") ? object.get("max").getAsFloat() : Float.MAX_VALUE;
        return new PercentBlockModifier(lowerVolumeSlider, upperVolumeSlider, min, max, (ImmutableCollection<class_2248>)blocks.build(), (ImmutableCollection<class_6862<class_2248>>)tags.build());
    }

    @Override
    public AtmosphericSoundModifier create(class_1937 world) {
        return this;
    }

    private static /* synthetic */ void lambda$create$0(ImmutableCollection.Builder tags, ImmutableCollection.Builder blocks, JsonElement block) {
        if (block.getAsString().startsWith("#")) {
            class_2960 tagId = new class_2960(block.getAsString().substring(1));
            class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)tagId);
            tags.add((Object)tagKey);
        } else {
            class_2960 blockId = new class_2960(block.getAsString());
            if (class_7923.field_41175.method_10250(blockId)) {
                class_2248 b = (class_2248)class_7923.field_41175.method_10223(blockId);
                blocks.add((Object)b);
            }
        }
    }
}

