/*
 * Decompiled with CFR 0.152.
 */
package dev.hephaestus.atmosfera.client.sound;

import dev.hephaestus.atmosfera.client.sound.modifiers.AtmosphericSoundModifier;
import dev.hephaestus.atmosfera.client.sound.modifiers.implementations.BossBarCondition;
import dev.hephaestus.atmosfera.client.sound.modifiers.implementations.DimensionEffectsModifier;
import dev.hephaestus.atmosfera.client.sound.modifiers.implementations.PercentBiomeModifier;
import dev.hephaestus.atmosfera.client.sound.modifiers.implementations.PercentBlockModifier;
import dev.hephaestus.atmosfera.client.sound.modifiers.implementations.RidingCondition;
import dev.hephaestus.atmosfera.client.sound.modifiers.implementations.SimpleBooleanCondition;
import dev.hephaestus.atmosfera.client.sound.modifiers.implementations.SimpleBoundedCondition;
import java.util.HashMap;
import java.util.Map;

public final class AtmosphericSoundModifierRegistry {
    private static final Map<String, AtmosphericSoundModifier.FactoryFactory> FACTORIES = new HashMap<String, AtmosphericSoundModifier.FactoryFactory>();

    private AtmosphericSoundModifierRegistry() {
    }

    public static void register(AtmosphericSoundModifier.FactoryFactory factory, String ... keys) {
        for (String key : keys) {
            FACTORIES.putIfAbsent(key, factory);
        }
    }

    public static void set(AtmosphericSoundModifier.FactoryFactory factory, String ... keys) {
        for (String key : keys) {
            FACTORIES.put(key, factory);
        }
    }

    public static AtmosphericSoundModifier.FactoryFactory get(String type) {
        return FACTORIES.get(type);
    }

    static {
        AtmosphericSoundModifierRegistry.register(SimpleBoundedCondition::altitude, "altitude", "distance_from_ground");
        AtmosphericSoundModifierRegistry.register(SimpleBoundedCondition::elevation, "elevation", "height");
        AtmosphericSoundModifierRegistry.register(SimpleBoundedCondition::skyVisibility, "sky_visibility", "percent_sky_visible");
        AtmosphericSoundModifierRegistry.register(SimpleBooleanCondition::isDaytime, "is_daytime");
        AtmosphericSoundModifierRegistry.register(SimpleBooleanCondition::isRainy, "is_rainy");
        AtmosphericSoundModifierRegistry.register(SimpleBooleanCondition::isStormy, "is_stormy");
        AtmosphericSoundModifierRegistry.register(PercentBlockModifier::create, "percent_block");
        AtmosphericSoundModifierRegistry.register(PercentBiomeModifier::create, "percent_biome");
        AtmosphericSoundModifierRegistry.register(RidingCondition::create, "vehicle", "riding");
        AtmosphericSoundModifierRegistry.register(DimensionEffectsModifier::create, "sky_properties", "dimension_effects");
        AtmosphericSoundModifierRegistry.register(BossBarCondition::create, "boss_bar");
    }
}

