/*
 * Decompiled with CFR 0.152.
 */
package dev.hephaestus.atmosfera.world.context;

import dev.hephaestus.atmosfera.world.context.EnvironmentContext;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2338;

public final class ContextUtil {
    public static final byte[][][][] OFFSETS = new byte[3][][][];
    public static final BlockingQueue<Runnable> TASK_QUEUE = new LinkedBlockingQueue<Runnable>();
    public static final ExecutorService EXECUTOR = new ThreadPoolExecutor(4, 16, 0L, TimeUnit.MILLISECONDS, TASK_QUEUE, runnable -> {
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        return thread;
    });

    private ContextUtil() {
    }

    static void init() {
    }

    static {
        EXECUTOR.execute(() -> {
            EnumMap<EnvironmentContext.Shape, Map> offsets = new EnumMap<EnvironmentContext.Shape, Map>(EnvironmentContext.Shape.class);
            for (EnvironmentContext.Size size : EnvironmentContext.Size.values()) {
                class_2338 origin = new class_2338(0, 0, 0);
                byte radius = size.radius;
                for (byte x = 0; x <= radius + 1; x = (byte)((byte)(x + 1))) {
                    for (byte y = (byte)(-radius); y <= 0; y = (byte)(y + 1)) {
                        for (byte z = 0; z <= radius + 1; z = (byte)((byte)(z + 1))) {
                            double distance = origin.method_10268((double)x, (double)y, (double)z);
                            if ((x + y + z) % 3 != 0 || !(distance <= (double)((radius + 1) * (radius + 1)))) continue;
                            offsets.computeIfAbsent(EnvironmentContext.Shape.LOWER_HEMISPHERE, key -> new EnumMap(EnvironmentContext.Size.class)).computeIfAbsent(size, key -> new HashSet()).add(new byte[]{x, y, z});
                            offsets.computeIfAbsent(EnvironmentContext.Shape.UPPER_HEMISPHERE, key -> new EnumMap(EnvironmentContext.Size.class)).computeIfAbsent(size, key -> new HashSet()).add(new byte[]{x, (byte)(-y + 1), z});
                            offsets.computeIfAbsent(EnvironmentContext.Shape.LOWER_HEMISPHERE, key -> new EnumMap(EnvironmentContext.Size.class)).computeIfAbsent(size, key -> new HashSet()).add(new byte[]{x, y, -z});
                            offsets.computeIfAbsent(EnvironmentContext.Shape.UPPER_HEMISPHERE, key -> new EnumMap(EnvironmentContext.Size.class)).computeIfAbsent(size, key -> new HashSet()).add(new byte[]{x, (byte)(-y + 1), -z});
                            offsets.computeIfAbsent(EnvironmentContext.Shape.LOWER_HEMISPHERE, key -> new EnumMap(EnvironmentContext.Size.class)).computeIfAbsent(size, key -> new HashSet()).add(new byte[]{-x, y, z});
                            offsets.computeIfAbsent(EnvironmentContext.Shape.UPPER_HEMISPHERE, key -> new EnumMap(EnvironmentContext.Size.class)).computeIfAbsent(size, key -> new HashSet()).add(new byte[]{-x, (byte)(-y + 1), z});
                            offsets.computeIfAbsent(EnvironmentContext.Shape.LOWER_HEMISPHERE, key -> new EnumMap(EnvironmentContext.Size.class)).computeIfAbsent(size, key -> new HashSet()).add(new byte[]{-x, y, -z});
                            offsets.computeIfAbsent(EnvironmentContext.Shape.UPPER_HEMISPHERE, key -> new EnumMap(EnvironmentContext.Size.class)).computeIfAbsent(size, key -> new HashSet()).add(new byte[]{-x, (byte)(-y + 1), -z});
                        }
                    }
                }
            }
            for (EnvironmentContext.Shape shape : offsets.keySet()) {
                int shapeOrdinal = shape.ordinal();
                Map shapes = (Map)offsets.get((Object)shape);
                ContextUtil.OFFSETS[shapeOrdinal] = new byte[shapes.size()][][];
                for (EnvironmentContext.Size size : shapes.keySet()) {
                    int sizeOrdinal = size.ordinal();
                    Collection sizes = (Collection)shapes.get((Object)size);
                    ContextUtil.OFFSETS[shapeOrdinal][sizeOrdinal] = new byte[sizes.size()][];
                    int i = 0;
                    for (byte[] bytes : sizes) {
                        ContextUtil.OFFSETS[shapeOrdinal][sizeOrdinal][i++] = bytes;
                    }
                }
            }
            boolean x = false;
        });
    }
}

