/*
 * Decompiled with CFR 0.152.
 */
package dev.hephaestus.atmosfera.client.sound.modifiers.implementations;

import com.google.gson.JsonObject;
import dev.hephaestus.atmosfera.client.sound.modifiers.AtmosphericSoundModifier;
import dev.hephaestus.atmosfera.world.context.EnvironmentContext;
import java.util.regex.Pattern;
import net.minecraft.class_1937;

public record BossBarCondition(String text, boolean isRegex) implements AtmosphericSoundModifier,
AtmosphericSoundModifier.Factory
{
    @Override
    public float getModifier(EnvironmentContext context) {
        if (this.isRegex) {
            for (String value : context.getBossBars()) {
                if (!Pattern.matches(this.text, value)) continue;
                return 1.0f;
            }
        } else if (context.getBossBars().contains(this.text)) {
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    public AtmosphericSoundModifier create(class_1937 world) {
        return this;
    }

    public static AtmosphericSoundModifier.Factory create(JsonObject object) {
        if (object.has("matches")) {
            return new BossBarCondition(object.get("matches").getAsString(), true);
        }
        if (object.has("text")) {
            return new BossBarCondition(object.get("text").getAsString(), false);
        }
        throw new RuntimeException("Modifier for 'boss_bar' is missing 'matches' or 'text' field.");
    }
}

