/*
 * Decompiled with CFR 0.152.
 */
package dev.hephaestus.atmosfera.client.sound;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import dev.hephaestus.atmosfera.Atmosfera;
import dev.hephaestus.atmosfera.client.sound.AtmosphericSound;
import dev.hephaestus.atmosfera.client.sound.AtmosphericSoundDefinition;
import dev.hephaestus.atmosfera.client.sound.AtmosphericSoundInstance;
import dev.hephaestus.atmosfera.client.sound.modifiers.AtmosphericSoundModifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1117;
import net.minecraft.class_1143;
import net.minecraft.class_1144;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_5195;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6880;

public class AtmosphericSoundHandler {
    private static final class_5819 RANDOM = class_5819.method_43047();
    private static final Map<AtmosphericSound, class_5195> MUSIC = new HashMap<AtmosphericSound, class_5195>();
    private final Collection<AtmosphericSound> sounds = new ArrayList<AtmosphericSound>();
    private final Collection<AtmosphericSound> musics = new ArrayList<AtmosphericSound>();
    private final Map<AtmosphericSound, AtmosphericSoundInstance> soundInstances = new WeakHashMap<AtmosphericSound, AtmosphericSoundInstance>();
    private final BlockingQueue<Runnable> taskQueue = new LinkedBlockingQueue<Runnable>();
    private final ExecutorService executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, this.taskQueue, runnable -> {
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        return thread;
    });

    public AtmosphericSoundHandler(class_638 world) {
        ImmutableList.Builder modifiers;
        for (AtmosphericSoundDefinition definition : Atmosfera.SOUND_DEFINITIONS.values()) {
            modifiers = ImmutableList.builder();
            for (AtmosphericSoundModifier.Factory factory : definition.modifiers()) {
                modifiers.add((Object)factory.create((class_1937)world));
            }
            this.sounds.add(new AtmosphericSound(definition.id(), definition.soundId(), definition.shape(), definition.size(), definition.defaultVolume(), definition.hasSubtitleByDefault(), (ImmutableCollection<AtmosphericSoundModifier>)modifiers.build()));
        }
        for (AtmosphericSoundDefinition definition : Atmosfera.MUSIC_DEFINITIONS.values()) {
            modifiers = ImmutableList.builder();
            for (AtmosphericSoundModifier.Factory factory : definition.modifiers()) {
                modifiers.add((Object)factory.create((class_1937)world));
            }
            this.musics.add(new AtmosphericSound(definition.id(), definition.soundId(), definition.shape(), definition.size(), definition.defaultVolume(), definition.hasSubtitleByDefault(), (ImmutableCollection<AtmosphericSoundModifier>)modifiers.build()));
        }
    }

    public void tick() {
        if (this.taskQueue.isEmpty()) {
            this.executor.execute(this::tickSounds);
        }
    }

    private void tickSounds() {
        class_638 world = class_310.method_1551().field_1687;
        if (world != null) {
            class_1144 soundManager = class_310.method_1551().method_1483();
            world.atmosfera$updateEnvironmentContext();
            for (AtmosphericSound definition : this.sounds) {
                float volume;
                if (this.soundInstances.containsKey(definition) && !this.soundInstances.get(definition).method_4793() || !((double)(volume = definition.getVolume(world)) >= 0.0125) || !(class_310.method_1551().field_1690.method_1630(class_3419.field_15256) > 0.0f)) continue;
                AtmosphericSoundInstance soundInstance = new AtmosphericSoundInstance(definition, 1.0E-4f);
                this.soundInstances.put(definition, soundInstance);
                soundManager.method_22140((class_1117)soundInstance);
                Atmosfera.debug("volume > 0: {} - {}", definition.id(), Float.valueOf(volume));
            }
        }
        this.soundInstances.values().removeIf(AtmosphericSoundInstance::method_4793);
    }

    public class_5195 getMusicSound(class_5195 defaultSound) {
        class_5195 result = defaultSound;
        class_638 world = class_310.method_1551().field_1687;
        if (world != null && class_310.method_1551().field_1690.method_1630(class_3419.field_15253) > 0.0f && class_310.method_1551().field_1724 != null && world.atmosfera$isEnvironmentContextInitialized()) {
            class_1144 soundManager = class_310.method_1551().method_1483();
            int total = Objects.requireNonNull(soundManager.method_4869(((class_3414)defaultSound.method_27279().comp_349()).method_14833())).method_4894();
            ArrayList<class_3545> sounds = new ArrayList<class_3545>();
            sounds.add(new class_3545((Object)total, (Object)defaultSound));
            for (AtmosphericSound definition : this.musics) {
                float volume = definition.getVolume(world);
                if (!((double)volume > 0.0125)) continue;
                int weight = Objects.requireNonNull(soundManager.method_4869(definition.soundId())).method_4894();
                sounds.add(new class_3545((Object)weight, (Object)MUSIC.computeIfAbsent(definition, id -> {
                    Atmosfera.debug("createIngameMusic: {}", definition.id());
                    return class_1143.method_27283((class_6880)class_6880.method_40223((Object)class_3414.method_47908((class_2960)definition.soundId())));
                })));
                total = (int)((float)total + 5.0f * volume);
            }
            int i = total <= 0 ? 0 : RANDOM.method_43048(total);
            for (class_3545 pair : sounds) {
                if ((i -= ((Integer)pair.method_15442()).intValue()) > 0) continue;
                result = (class_5195)pair.method_15441();
            }
            sounds.clear();
        }
        return result;
    }
}

