/*
 * Decompiled with CFR 0.152.
 */
package dev.hephaestus.atmosfera;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.hephaestus.atmosfera.Atmosfera;
import dev.hephaestus.atmosfera.client.sound.AtmosphericSoundDefinition;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.constant.Constable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class AtmosferaConfig {
    private static final boolean IS_DEVELOPMENT_ENVIRONMENT = FabricLoader.getInstance().isDevelopmentEnvironment();
    private static final TreeMap<class_2960, Integer> VOLUME_MODIFIERS = new TreeMap(Comparator.comparing(id -> class_1074.method_4662((String)id.toString(), (Object[])new Object[0])));
    private static final TreeMap<class_2960, Boolean> SUBTITLE_MODIFIERS = new TreeMap(Comparator.comparing(id -> class_1074.method_4662((String)id.toString(), (Object[])new Object[0])));
    private static final TreeMap<class_2960, Integer> MUSIC_WEIGHTS = new TreeMap(Comparator.comparing(id -> class_1074.method_4662((String)id.toString(), (Object[])new Object[0])));
    private static boolean PRINT_DEBUG_MESSAGES = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void read() {
        block16: {
            try {
                JsonObject debug;
                Iterator<AtmosphericSoundDefinition> fi = new FileInputStream("config" + File.separator + "atmosfera.json");
                JsonParser jsonParser = new JsonParser();
                JsonObject json = (JsonObject)jsonParser.parse((Reader)new InputStreamReader((InputStream)((Object)fi)));
                if (json.has("volumes")) {
                    for (Map.Entry element : json.get("volumes").getAsJsonObject().entrySet()) {
                        if (!((JsonElement)element.getValue()).isJsonPrimitive()) continue;
                        VOLUME_MODIFIERS.put(new class_2960((String)element.getKey()), ((JsonElement)element.getValue()).getAsInt());
                    }
                }
                if (json.has("subtitles")) {
                    for (Map.Entry element : json.get("subtitles").getAsJsonObject().entrySet()) {
                        if (!((JsonElement)element.getValue()).isJsonPrimitive()) continue;
                        SUBTITLE_MODIFIERS.put(new class_2960((String)element.getKey()), ((JsonElement)element.getValue()).getAsBoolean());
                    }
                }
                if (json.has("debug") && (debug = json.getAsJsonObject("debug")).has("print_debug_messages")) {
                    PRINT_DEBUG_MESSAGES = debug.get("print_debug_messages").getAsBoolean();
                }
                ((InputStream)((Object)fi)).close();
            }
            catch (FileNotFoundException e) {
                Atmosfera.log("The user config file was not found. Creating the default config...", new Object[0]);
                break block16;
            }
            catch (IOException e2) {
                e2.printStackTrace();
                break block16;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                for (AtmosphericSoundDefinition sound : Atmosfera.SOUND_DEFINITIONS.values()) {
                    VOLUME_MODIFIERS.putIfAbsent(sound.id(), sound.defaultVolume());
                    SUBTITLE_MODIFIERS.putIfAbsent(sound.id(), sound.hasSubtitleByDefault());
                }
                for (AtmosphericSoundDefinition sound : Atmosfera.MUSIC_DEFINITIONS.values()) {
                    VOLUME_MODIFIERS.putIfAbsent(sound.id(), sound.defaultVolume());
                }
                AtmosferaConfig.write();
            }
            for (AtmosphericSoundDefinition sound : Atmosfera.SOUND_DEFINITIONS.values()) {
                VOLUME_MODIFIERS.putIfAbsent(sound.id(), sound.defaultVolume());
                SUBTITLE_MODIFIERS.putIfAbsent(sound.id(), sound.hasSubtitleByDefault());
            }
            for (AtmosphericSoundDefinition sound : Atmosfera.MUSIC_DEFINITIONS.values()) {
                VOLUME_MODIFIERS.putIfAbsent(sound.id(), sound.defaultVolume());
            }
            AtmosferaConfig.write();
        }
    }

    private static void write() {
        File configFile = new File("config" + File.separator + "atmosfera.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(configFile));
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("volumes", gson.toJsonTree(VOLUME_MODIFIERS));
            jsonObject.add("subtitles", gson.toJsonTree(SUBTITLE_MODIFIERS));
            JsonObject debug = new JsonObject();
            debug.addProperty("print_debug_messages", Boolean.valueOf(PRINT_DEBUG_MESSAGES));
            jsonObject.add("debug", (JsonElement)debug);
            writer.write(gson.toJson((JsonElement)jsonObject));
            writer.close();
        }
        catch (IOException e) {
            Atmosfera.warn("Failed to save the config to the file.", new Object[0]);
        }
    }

    public static float volumeModifier(class_2960 soundId) {
        try {
            return (float)VOLUME_MODIFIERS.getOrDefault(soundId, Atmosfera.SOUND_DEFINITIONS.getOrDefault(soundId, Atmosfera.MUSIC_DEFINITIONS.get(soundId)).defaultVolume()).intValue() / 100.0f;
        }
        catch (NullPointerException e) {
            Atmosfera.warn("Unknown sound: {}", soundId);
            throw e;
        }
    }

    public static boolean showSubtitle(class_2960 soundId) {
        return SUBTITLE_MODIFIERS.getOrDefault(soundId, Atmosfera.SOUND_DEFINITIONS.get(soundId).hasSubtitleByDefault());
    }

    public static int weight(class_2960 musicId) {
        return MUSIC_WEIGHTS.getOrDefault(musicId, 5);
    }

    public static void refreshConfig() {
        Atmosfera.warn("Refreshing the user config...", new Object[0]);
        AtmosferaConfig.read();
    }

    public static class_437 getScreen(class_437 parent) {
        AtmosferaConfig.read();
        ConfigBuilder builder = ConfigBuilder.create().setTitle((class_2561)class_2561.method_43470((String)"Atmosfera"));
        builder.setParentScreen(parent);
        ConfigCategory volumesCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"config.category.atmosfera.volumes"));
        ConfigCategory subtitlesCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"config.category.atmosfera.subtitles"));
        if (IS_DEVELOPMENT_ENVIRONMENT) {
            ConfigCategory debugCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"config.category.atmosfera.debug"));
            debugCategory.addEntry((AbstractConfigListEntry)new BooleanToggleBuilder((class_2561)class_2561.method_43471((String)"text.cloth-config.reset_value"), (class_2561)class_2561.method_43471((String)"config.value.atmosfera.print_debug_messages"), false).setSaveConsumer(b -> {
                PRINT_DEBUG_MESSAGES = b;
            }).build());
        }
        SubCategoryBuilder soundSubcategory = new SubCategoryBuilder((class_2561)class_2561.method_43471((String)"text.cloth-config.reset_value"), (class_2561)class_2561.method_43471((String)"config.subcategory.atmosfera.ambient_sound")).setExpanded(true);
        SubCategoryBuilder musicSubcategory = new SubCategoryBuilder((class_2561)class_2561.method_43471((String)"text.cloth-config.reset_value"), (class_2561)class_2561.method_43471((String)"config.subcategory.atmosfera.music")).setExpanded(true);
        builder.setDefaultBackgroundTexture(new class_2960("minecraft:textures/block/light_blue_stained_glass.png"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        for (Map.Entry<class_2960, Integer> entry : VOLUME_MODIFIERS.entrySet()) {
            String soundLangID;
            Map<class_2960, AtmosphericSoundDefinition> soundType;
            if (Atmosfera.SOUND_DEFINITIONS.containsKey(entry.getKey())) {
                soundType = Atmosfera.SOUND_DEFINITIONS;
                if (!soundType.containsKey(entry.getKey())) continue;
                soundLangID = String.join((CharSequence)".", entry.getKey().toString().split(":"));
                class_5250 tooltipText = class_2561.method_43470((String)(soundLangID + "\n"));
                tooltipText.method_10852((class_2561)class_2561.method_43471((String)("subtitle." + soundLangID)));
                soundSubcategory.add((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)class_2561.method_43471((String)soundLangID), entry.getValue().intValue(), 0, 200).setDefaultValue(soundType.get(entry.getKey()).defaultVolume()).setTooltip(new class_2561[]{tooltipText.method_27692(class_124.field_1080)}).setTextGetter(integer -> class_2561.method_43470((String)(integer + "%"))).setSaveConsumer(volume -> VOLUME_MODIFIERS.put((class_2960)sound.getKey(), (Integer)volume)).build());
                continue;
            }
            soundType = Atmosfera.MUSIC_DEFINITIONS;
            if (!soundType.containsKey(entry.getKey())) continue;
            soundLangID = String.join((CharSequence)".", entry.getKey().toString().split(":"));
            musicSubcategory.add((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)class_2561.method_43471((String)soundLangID), entry.getValue().intValue(), 0, 200).setDefaultValue(soundType.get(entry.getKey()).defaultVolume()).setTooltip(new class_2561[]{class_2561.method_43470((String)soundLangID).method_27692(class_124.field_1080)}).setTextGetter(integer -> class_2561.method_43470((String)(integer + "%"))).setSaveConsumer(volume -> VOLUME_MODIFIERS.put((class_2960)sound.getKey(), (Integer)volume)).build());
        }
        volumesCategory.addEntry((AbstractConfigListEntry)soundSubcategory.build());
        volumesCategory.addEntry((AbstractConfigListEntry)musicSubcategory.build());
        for (Map.Entry<class_2960, Constable> entry : SUBTITLE_MODIFIERS.entrySet()) {
            if (!Atmosfera.SOUND_DEFINITIONS.containsKey(entry.getKey())) continue;
            String soundLangID = String.join((CharSequence)".", entry.getKey().toString().split(":"));
            class_5250 tooltipText = class_2561.method_43470((String)(soundLangID + "\n"));
            tooltipText.method_10852((class_2561)class_2561.method_43471((String)("subtitle." + soundLangID)));
            subtitlesCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)soundLangID), ((Boolean)entry.getValue()).booleanValue()).setDefaultValue(Atmosfera.SOUND_DEFINITIONS.get(entry.getKey()).hasSubtitleByDefault()).setTooltip(new class_2561[]{tooltipText.method_27692(class_124.field_1080)}).setSaveConsumer(subtitle -> SUBTITLE_MODIFIERS.put((class_2960)sound.getKey(), (Boolean)subtitle)).build());
        }
        if (soundSubcategory.size() + musicSubcategory.size() == 0) {
            subtitlesCategory.removeCategory();
            volumesCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43471((String)"config.atmosfera.resource_pack_warning").method_27692(class_124.field_1061)).build());
        }
        builder.setSavingRunnable(AtmosferaConfig::write);
        return builder.build();
    }

    public static boolean printDebugMessages() {
        return PRINT_DEBUG_MESSAGES && IS_DEVELOPMENT_ENVIRONMENT;
    }

    static {
        AtmosferaConfig.read();
    }
}

